<?php
/**
 * DomainsApi
 * PHP version 7.4
 *
 * @category Class
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * orchd
 *
 * orchd API docs
 *
 * The version of the OpenAPI document: 9.1.1
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.4.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace OpenAPI\Client\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use OpenAPI\Client\ApiException;
use OpenAPI\Client\Configuration;
use OpenAPI\Client\HeaderSelector;
use OpenAPI\Client\ObjectSerializer;

/**
 * DomainsApi Class Doc Comment
 *
 * @category Class
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class DomainsApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'checkDomain' => [
            'application/json',
        ],
        'createDomain' => [
            'application/json',
        ],
        'createWebsiteDomainAlias' => [
            'application/json',
        ],
        'createWebsiteDomainLetsencryptCerts' => [
            'application/json',
        ],
        'deleteCloudflareApiKeyId' => [
            'application/json',
        ],
        'deleteDomain' => [
            'application/json',
        ],
        'deleteWebsiteDomainMapping' => [
            'application/json',
        ],
        'getCloudflareApiKeyDomain' => [
            'application/json',
        ],
        'getCloudflareNameServers' => [
            'application/json',
        ],
        'getDomains' => [
            'application/json',
        ],
        'getWebsiteDomainDnsQuery' => [
            'application/json',
        ],
        'getWebsiteDomainMapping' => [
            'application/json',
        ],
        'getWebsiteDomainMappingDnsStatus' => [
            'application/json',
        ],
        'getWebsiteDomainMappings' => [
            'application/json',
        ],
        'setCloudflareApiKeyId' => [
            'application/json',
        ],
        'updateWebsiteDomainMapping' => [
            'application/json',
        ],
        'updateWebsitePrimaryDomain' => [
            'application/json',
        ],
    ];

/**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation checkDomain
     *
     * Check if a domain can be created
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  \OpenAPI\Client\Model\NewDomain $new_domain Domain details. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['checkDomain'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\DomainInUseStatus
     */
    public function checkDomain($org_id, $new_domain, string $contentType = self::contentTypes['checkDomain'][0])
    {
        list($response) = $this->checkDomainWithHttpInfo($org_id, $new_domain, $contentType);
        return $response;
    }

    /**
     * Operation checkDomainWithHttpInfo
     *
     * Check if a domain can be created
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  \OpenAPI\Client\Model\NewDomain $new_domain Domain details. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['checkDomain'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\DomainInUseStatus, HTTP status code, HTTP response headers (array of strings)
     */
    public function checkDomainWithHttpInfo($org_id, $new_domain, string $contentType = self::contentTypes['checkDomain'][0])
    {
        $request = $this->checkDomainRequest($org_id, $new_domain, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\OpenAPI\Client\Model\DomainInUseStatus' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\OpenAPI\Client\Model\DomainInUseStatus' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\OpenAPI\Client\Model\DomainInUseStatus', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\OpenAPI\Client\Model\DomainInUseStatus';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\DomainInUseStatus',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation checkDomainAsync
     *
     * Check if a domain can be created
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  \OpenAPI\Client\Model\NewDomain $new_domain Domain details. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['checkDomain'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function checkDomainAsync($org_id, $new_domain, string $contentType = self::contentTypes['checkDomain'][0])
    {
        return $this->checkDomainAsyncWithHttpInfo($org_id, $new_domain, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation checkDomainAsyncWithHttpInfo
     *
     * Check if a domain can be created
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  \OpenAPI\Client\Model\NewDomain $new_domain Domain details. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['checkDomain'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function checkDomainAsyncWithHttpInfo($org_id, $new_domain, string $contentType = self::contentTypes['checkDomain'][0])
    {
        $returnType = '\OpenAPI\Client\Model\DomainInUseStatus';
        $request = $this->checkDomainRequest($org_id, $new_domain, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'checkDomain'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  \OpenAPI\Client\Model\NewDomain $new_domain Domain details. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['checkDomain'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function checkDomainRequest($org_id, $new_domain, string $contentType = self::contentTypes['checkDomain'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling checkDomain'
            );
        }

        // verify the required parameter 'new_domain' is set
        if ($new_domain === null || (is_array($new_domain) && count($new_domain) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $new_domain when calling checkDomain'
            );
        }


        $resourcePath = '/orgs/{org_id}/domains/check';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($new_domain)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($new_domain));
            } else {
                $httpBody = $new_domain;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createDomain
     *
     * Create domain
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  \OpenAPI\Client\Model\NewDomain $new_domain Domain details. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createDomain'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\NewResourceUuid
     */
    public function createDomain($org_id, $new_domain, string $contentType = self::contentTypes['createDomain'][0])
    {
        list($response) = $this->createDomainWithHttpInfo($org_id, $new_domain, $contentType);
        return $response;
    }

    /**
     * Operation createDomainWithHttpInfo
     *
     * Create domain
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  \OpenAPI\Client\Model\NewDomain $new_domain Domain details. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createDomain'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\NewResourceUuid, HTTP status code, HTTP response headers (array of strings)
     */
    public function createDomainWithHttpInfo($org_id, $new_domain, string $contentType = self::contentTypes['createDomain'][0])
    {
        $request = $this->createDomainRequest($org_id, $new_domain, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 201:
                    if ('\OpenAPI\Client\Model\NewResourceUuid' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\OpenAPI\Client\Model\NewResourceUuid' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\OpenAPI\Client\Model\NewResourceUuid', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\OpenAPI\Client\Model\NewResourceUuid';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\NewResourceUuid',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createDomainAsync
     *
     * Create domain
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  \OpenAPI\Client\Model\NewDomain $new_domain Domain details. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createDomain'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createDomainAsync($org_id, $new_domain, string $contentType = self::contentTypes['createDomain'][0])
    {
        return $this->createDomainAsyncWithHttpInfo($org_id, $new_domain, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createDomainAsyncWithHttpInfo
     *
     * Create domain
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  \OpenAPI\Client\Model\NewDomain $new_domain Domain details. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createDomain'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createDomainAsyncWithHttpInfo($org_id, $new_domain, string $contentType = self::contentTypes['createDomain'][0])
    {
        $returnType = '\OpenAPI\Client\Model\NewResourceUuid';
        $request = $this->createDomainRequest($org_id, $new_domain, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createDomain'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  \OpenAPI\Client\Model\NewDomain $new_domain Domain details. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createDomain'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createDomainRequest($org_id, $new_domain, string $contentType = self::contentTypes['createDomain'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling createDomain'
            );
        }

        // verify the required parameter 'new_domain' is set
        if ($new_domain === null || (is_array($new_domain) && count($new_domain) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $new_domain when calling createDomain'
            );
        }


        $resourcePath = '/orgs/{org_id}/domains';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($new_domain)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($new_domain));
            } else {
                $httpBody = $new_domain;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createWebsiteDomainAlias
     *
     * Create website domain alias
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  \OpenAPI\Client\Model\NewDomainAlias $new_domain_alias Domain details. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createWebsiteDomainAlias'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\NewResourceUuid
     */
    public function createWebsiteDomainAlias($org_id, $website_id, $new_domain_alias, string $contentType = self::contentTypes['createWebsiteDomainAlias'][0])
    {
        list($response) = $this->createWebsiteDomainAliasWithHttpInfo($org_id, $website_id, $new_domain_alias, $contentType);
        return $response;
    }

    /**
     * Operation createWebsiteDomainAliasWithHttpInfo
     *
     * Create website domain alias
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  \OpenAPI\Client\Model\NewDomainAlias $new_domain_alias Domain details. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createWebsiteDomainAlias'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\NewResourceUuid, HTTP status code, HTTP response headers (array of strings)
     */
    public function createWebsiteDomainAliasWithHttpInfo($org_id, $website_id, $new_domain_alias, string $contentType = self::contentTypes['createWebsiteDomainAlias'][0])
    {
        $request = $this->createWebsiteDomainAliasRequest($org_id, $website_id, $new_domain_alias, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 201:
                    if ('\OpenAPI\Client\Model\NewResourceUuid' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\OpenAPI\Client\Model\NewResourceUuid' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\OpenAPI\Client\Model\NewResourceUuid', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\OpenAPI\Client\Model\NewResourceUuid';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\NewResourceUuid',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createWebsiteDomainAliasAsync
     *
     * Create website domain alias
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  \OpenAPI\Client\Model\NewDomainAlias $new_domain_alias Domain details. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createWebsiteDomainAlias'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createWebsiteDomainAliasAsync($org_id, $website_id, $new_domain_alias, string $contentType = self::contentTypes['createWebsiteDomainAlias'][0])
    {
        return $this->createWebsiteDomainAliasAsyncWithHttpInfo($org_id, $website_id, $new_domain_alias, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createWebsiteDomainAliasAsyncWithHttpInfo
     *
     * Create website domain alias
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  \OpenAPI\Client\Model\NewDomainAlias $new_domain_alias Domain details. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createWebsiteDomainAlias'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createWebsiteDomainAliasAsyncWithHttpInfo($org_id, $website_id, $new_domain_alias, string $contentType = self::contentTypes['createWebsiteDomainAlias'][0])
    {
        $returnType = '\OpenAPI\Client\Model\NewResourceUuid';
        $request = $this->createWebsiteDomainAliasRequest($org_id, $website_id, $new_domain_alias, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createWebsiteDomainAlias'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  \OpenAPI\Client\Model\NewDomainAlias $new_domain_alias Domain details. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createWebsiteDomainAlias'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createWebsiteDomainAliasRequest($org_id, $website_id, $new_domain_alias, string $contentType = self::contentTypes['createWebsiteDomainAlias'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling createWebsiteDomainAlias'
            );
        }

        // verify the required parameter 'website_id' is set
        if ($website_id === null || (is_array($website_id) && count($website_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $website_id when calling createWebsiteDomainAlias'
            );
        }

        // verify the required parameter 'new_domain_alias' is set
        if ($new_domain_alias === null || (is_array($new_domain_alias) && count($new_domain_alias) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $new_domain_alias when calling createWebsiteDomainAlias'
            );
        }


        $resourcePath = '/orgs/{org_id}/websites/{website_id}/domains';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($website_id !== null) {
            $resourcePath = str_replace(
                '{' . 'website_id' . '}',
                ObjectSerializer::toPathValue($website_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($new_domain_alias)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($new_domain_alias));
            } else {
                $httpBody = $new_domain_alias;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createWebsiteDomainLetsencryptCerts
     *
     * Generate and setup letsencrypt ssl certificates for website&#39;s domain
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  bool $dry_run If not set or &#x60;dry_run&#x3D;true&#x60; it will only verify domain ownership and get dummy certificates. To enable SSL on domain set &#x60;?dry_run&#x3D;false&#x60;. (optional)
     * @param  bool $enable Defaults to &#x60;enable&#x3D;true&#x60; if not set. To only generate and save certificate in db set &#x60;enable&#x3D;false&#x60;. It has no bearing if &#x60;dry_run&#x3D;false&#x60; not set. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createWebsiteDomainLetsencryptCerts'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function createWebsiteDomainLetsencryptCerts($org_id, $website_id, $domain_id, $dry_run = null, $enable = null, string $contentType = self::contentTypes['createWebsiteDomainLetsencryptCerts'][0])
    {
        $this->createWebsiteDomainLetsencryptCertsWithHttpInfo($org_id, $website_id, $domain_id, $dry_run, $enable, $contentType);
    }

    /**
     * Operation createWebsiteDomainLetsencryptCertsWithHttpInfo
     *
     * Generate and setup letsencrypt ssl certificates for website&#39;s domain
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  bool $dry_run If not set or &#x60;dry_run&#x3D;true&#x60; it will only verify domain ownership and get dummy certificates. To enable SSL on domain set &#x60;?dry_run&#x3D;false&#x60;. (optional)
     * @param  bool $enable Defaults to &#x60;enable&#x3D;true&#x60; if not set. To only generate and save certificate in db set &#x60;enable&#x3D;false&#x60;. It has no bearing if &#x60;dry_run&#x3D;false&#x60; not set. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createWebsiteDomainLetsencryptCerts'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function createWebsiteDomainLetsencryptCertsWithHttpInfo($org_id, $website_id, $domain_id, $dry_run = null, $enable = null, string $contentType = self::contentTypes['createWebsiteDomainLetsencryptCerts'][0])
    {
        $request = $this->createWebsiteDomainLetsencryptCertsRequest($org_id, $website_id, $domain_id, $dry_run, $enable, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation createWebsiteDomainLetsencryptCertsAsync
     *
     * Generate and setup letsencrypt ssl certificates for website&#39;s domain
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  bool $dry_run If not set or &#x60;dry_run&#x3D;true&#x60; it will only verify domain ownership and get dummy certificates. To enable SSL on domain set &#x60;?dry_run&#x3D;false&#x60;. (optional)
     * @param  bool $enable Defaults to &#x60;enable&#x3D;true&#x60; if not set. To only generate and save certificate in db set &#x60;enable&#x3D;false&#x60;. It has no bearing if &#x60;dry_run&#x3D;false&#x60; not set. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createWebsiteDomainLetsencryptCerts'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createWebsiteDomainLetsencryptCertsAsync($org_id, $website_id, $domain_id, $dry_run = null, $enable = null, string $contentType = self::contentTypes['createWebsiteDomainLetsencryptCerts'][0])
    {
        return $this->createWebsiteDomainLetsencryptCertsAsyncWithHttpInfo($org_id, $website_id, $domain_id, $dry_run, $enable, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createWebsiteDomainLetsencryptCertsAsyncWithHttpInfo
     *
     * Generate and setup letsencrypt ssl certificates for website&#39;s domain
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  bool $dry_run If not set or &#x60;dry_run&#x3D;true&#x60; it will only verify domain ownership and get dummy certificates. To enable SSL on domain set &#x60;?dry_run&#x3D;false&#x60;. (optional)
     * @param  bool $enable Defaults to &#x60;enable&#x3D;true&#x60; if not set. To only generate and save certificate in db set &#x60;enable&#x3D;false&#x60;. It has no bearing if &#x60;dry_run&#x3D;false&#x60; not set. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createWebsiteDomainLetsencryptCerts'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createWebsiteDomainLetsencryptCertsAsyncWithHttpInfo($org_id, $website_id, $domain_id, $dry_run = null, $enable = null, string $contentType = self::contentTypes['createWebsiteDomainLetsencryptCerts'][0])
    {
        $returnType = '';
        $request = $this->createWebsiteDomainLetsencryptCertsRequest($org_id, $website_id, $domain_id, $dry_run, $enable, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createWebsiteDomainLetsencryptCerts'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  bool $dry_run If not set or &#x60;dry_run&#x3D;true&#x60; it will only verify domain ownership and get dummy certificates. To enable SSL on domain set &#x60;?dry_run&#x3D;false&#x60;. (optional)
     * @param  bool $enable Defaults to &#x60;enable&#x3D;true&#x60; if not set. To only generate and save certificate in db set &#x60;enable&#x3D;false&#x60;. It has no bearing if &#x60;dry_run&#x3D;false&#x60; not set. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createWebsiteDomainLetsencryptCerts'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createWebsiteDomainLetsencryptCertsRequest($org_id, $website_id, $domain_id, $dry_run = null, $enable = null, string $contentType = self::contentTypes['createWebsiteDomainLetsencryptCerts'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling createWebsiteDomainLetsencryptCerts'
            );
        }

        // verify the required parameter 'website_id' is set
        if ($website_id === null || (is_array($website_id) && count($website_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $website_id when calling createWebsiteDomainLetsencryptCerts'
            );
        }

        // verify the required parameter 'domain_id' is set
        if ($domain_id === null || (is_array($domain_id) && count($domain_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $domain_id when calling createWebsiteDomainLetsencryptCerts'
            );
        }




        $resourcePath = '/orgs/{org_id}/websites/{website_id}/domains/{domain_id}/letsencrypt';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $dry_run,
            'dryRun', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $enable,
            'enable', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($website_id !== null) {
            $resourcePath = str_replace(
                '{' . 'website_id' . '}',
                ObjectSerializer::toPathValue($website_id),
                $resourcePath
            );
        }
        // path params
        if ($domain_id !== null) {
            $resourcePath = str_replace(
                '{' . 'domain_id' . '}',
                ObjectSerializer::toPathValue($domain_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteCloudflareApiKeyId
     *
     * Delete CloudFlare API key, domain level
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteCloudflareApiKeyId'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteCloudflareApiKeyId($org_id, $domain_id, string $contentType = self::contentTypes['deleteCloudflareApiKeyId'][0])
    {
        $this->deleteCloudflareApiKeyIdWithHttpInfo($org_id, $domain_id, $contentType);
    }

    /**
     * Operation deleteCloudflareApiKeyIdWithHttpInfo
     *
     * Delete CloudFlare API key, domain level
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteCloudflareApiKeyId'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteCloudflareApiKeyIdWithHttpInfo($org_id, $domain_id, string $contentType = self::contentTypes['deleteCloudflareApiKeyId'][0])
    {
        $request = $this->deleteCloudflareApiKeyIdRequest($org_id, $domain_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteCloudflareApiKeyIdAsync
     *
     * Delete CloudFlare API key, domain level
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteCloudflareApiKeyId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteCloudflareApiKeyIdAsync($org_id, $domain_id, string $contentType = self::contentTypes['deleteCloudflareApiKeyId'][0])
    {
        return $this->deleteCloudflareApiKeyIdAsyncWithHttpInfo($org_id, $domain_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteCloudflareApiKeyIdAsyncWithHttpInfo
     *
     * Delete CloudFlare API key, domain level
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteCloudflareApiKeyId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteCloudflareApiKeyIdAsyncWithHttpInfo($org_id, $domain_id, string $contentType = self::contentTypes['deleteCloudflareApiKeyId'][0])
    {
        $returnType = '';
        $request = $this->deleteCloudflareApiKeyIdRequest($org_id, $domain_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteCloudflareApiKeyId'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteCloudflareApiKeyId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteCloudflareApiKeyIdRequest($org_id, $domain_id, string $contentType = self::contentTypes['deleteCloudflareApiKeyId'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling deleteCloudflareApiKeyId'
            );
        }

        // verify the required parameter 'domain_id' is set
        if ($domain_id === null || (is_array($domain_id) && count($domain_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $domain_id when calling deleteCloudflareApiKeyId'
            );
        }


        $resourcePath = '/orgs/{org_id}/domains/{domain_id}/cloudflare';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($domain_id !== null) {
            $resourcePath = str_replace(
                '{' . 'domain_id' . '}',
                ObjectSerializer::toPathValue($domain_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteDomain
     *
     * Delete domain
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteDomain'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteDomain($org_id, $domain_id, string $contentType = self::contentTypes['deleteDomain'][0])
    {
        $this->deleteDomainWithHttpInfo($org_id, $domain_id, $contentType);
    }

    /**
     * Operation deleteDomainWithHttpInfo
     *
     * Delete domain
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteDomain'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteDomainWithHttpInfo($org_id, $domain_id, string $contentType = self::contentTypes['deleteDomain'][0])
    {
        $request = $this->deleteDomainRequest($org_id, $domain_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteDomainAsync
     *
     * Delete domain
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteDomain'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteDomainAsync($org_id, $domain_id, string $contentType = self::contentTypes['deleteDomain'][0])
    {
        return $this->deleteDomainAsyncWithHttpInfo($org_id, $domain_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteDomainAsyncWithHttpInfo
     *
     * Delete domain
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteDomain'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteDomainAsyncWithHttpInfo($org_id, $domain_id, string $contentType = self::contentTypes['deleteDomain'][0])
    {
        $returnType = '';
        $request = $this->deleteDomainRequest($org_id, $domain_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteDomain'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteDomain'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteDomainRequest($org_id, $domain_id, string $contentType = self::contentTypes['deleteDomain'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling deleteDomain'
            );
        }

        // verify the required parameter 'domain_id' is set
        if ($domain_id === null || (is_array($domain_id) && count($domain_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $domain_id when calling deleteDomain'
            );
        }


        $resourcePath = '/orgs/{org_id}/domains/{domain_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($domain_id !== null) {
            $resourcePath = str_replace(
                '{' . 'domain_id' . '}',
                ObjectSerializer::toPathValue($domain_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteWebsiteDomainMapping
     *
     * Delete website domain mapping
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteWebsiteDomainMapping'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteWebsiteDomainMapping($org_id, $website_id, $domain_id, string $contentType = self::contentTypes['deleteWebsiteDomainMapping'][0])
    {
        $this->deleteWebsiteDomainMappingWithHttpInfo($org_id, $website_id, $domain_id, $contentType);
    }

    /**
     * Operation deleteWebsiteDomainMappingWithHttpInfo
     *
     * Delete website domain mapping
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteWebsiteDomainMapping'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteWebsiteDomainMappingWithHttpInfo($org_id, $website_id, $domain_id, string $contentType = self::contentTypes['deleteWebsiteDomainMapping'][0])
    {
        $request = $this->deleteWebsiteDomainMappingRequest($org_id, $website_id, $domain_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteWebsiteDomainMappingAsync
     *
     * Delete website domain mapping
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteWebsiteDomainMapping'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteWebsiteDomainMappingAsync($org_id, $website_id, $domain_id, string $contentType = self::contentTypes['deleteWebsiteDomainMapping'][0])
    {
        return $this->deleteWebsiteDomainMappingAsyncWithHttpInfo($org_id, $website_id, $domain_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteWebsiteDomainMappingAsyncWithHttpInfo
     *
     * Delete website domain mapping
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteWebsiteDomainMapping'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteWebsiteDomainMappingAsyncWithHttpInfo($org_id, $website_id, $domain_id, string $contentType = self::contentTypes['deleteWebsiteDomainMapping'][0])
    {
        $returnType = '';
        $request = $this->deleteWebsiteDomainMappingRequest($org_id, $website_id, $domain_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteWebsiteDomainMapping'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteWebsiteDomainMapping'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteWebsiteDomainMappingRequest($org_id, $website_id, $domain_id, string $contentType = self::contentTypes['deleteWebsiteDomainMapping'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling deleteWebsiteDomainMapping'
            );
        }

        // verify the required parameter 'website_id' is set
        if ($website_id === null || (is_array($website_id) && count($website_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $website_id when calling deleteWebsiteDomainMapping'
            );
        }

        // verify the required parameter 'domain_id' is set
        if ($domain_id === null || (is_array($domain_id) && count($domain_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $domain_id when calling deleteWebsiteDomainMapping'
            );
        }


        $resourcePath = '/orgs/{org_id}/websites/{website_id}/domains/{domain_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($website_id !== null) {
            $resourcePath = str_replace(
                '{' . 'website_id' . '}',
                ObjectSerializer::toPathValue($website_id),
                $resourcePath
            );
        }
        // path params
        if ($domain_id !== null) {
            $resourcePath = str_replace(
                '{' . 'domain_id' . '}',
                ObjectSerializer::toPathValue($domain_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getCloudflareApiKeyDomain
     *
     * Get CloudFlare API key, domain level
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCloudflareApiKeyDomain'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\CloudFlareApiKey
     */
    public function getCloudflareApiKeyDomain($org_id, $domain_id, string $contentType = self::contentTypes['getCloudflareApiKeyDomain'][0])
    {
        list($response) = $this->getCloudflareApiKeyDomainWithHttpInfo($org_id, $domain_id, $contentType);
        return $response;
    }

    /**
     * Operation getCloudflareApiKeyDomainWithHttpInfo
     *
     * Get CloudFlare API key, domain level
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCloudflareApiKeyDomain'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\CloudFlareApiKey, HTTP status code, HTTP response headers (array of strings)
     */
    public function getCloudflareApiKeyDomainWithHttpInfo($org_id, $domain_id, string $contentType = self::contentTypes['getCloudflareApiKeyDomain'][0])
    {
        $request = $this->getCloudflareApiKeyDomainRequest($org_id, $domain_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\OpenAPI\Client\Model\CloudFlareApiKey' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\OpenAPI\Client\Model\CloudFlareApiKey' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\OpenAPI\Client\Model\CloudFlareApiKey', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\OpenAPI\Client\Model\CloudFlareApiKey';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\CloudFlareApiKey',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getCloudflareApiKeyDomainAsync
     *
     * Get CloudFlare API key, domain level
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCloudflareApiKeyDomain'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getCloudflareApiKeyDomainAsync($org_id, $domain_id, string $contentType = self::contentTypes['getCloudflareApiKeyDomain'][0])
    {
        return $this->getCloudflareApiKeyDomainAsyncWithHttpInfo($org_id, $domain_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getCloudflareApiKeyDomainAsyncWithHttpInfo
     *
     * Get CloudFlare API key, domain level
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCloudflareApiKeyDomain'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getCloudflareApiKeyDomainAsyncWithHttpInfo($org_id, $domain_id, string $contentType = self::contentTypes['getCloudflareApiKeyDomain'][0])
    {
        $returnType = '\OpenAPI\Client\Model\CloudFlareApiKey';
        $request = $this->getCloudflareApiKeyDomainRequest($org_id, $domain_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getCloudflareApiKeyDomain'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCloudflareApiKeyDomain'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getCloudflareApiKeyDomainRequest($org_id, $domain_id, string $contentType = self::contentTypes['getCloudflareApiKeyDomain'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling getCloudflareApiKeyDomain'
            );
        }

        // verify the required parameter 'domain_id' is set
        if ($domain_id === null || (is_array($domain_id) && count($domain_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $domain_id when calling getCloudflareApiKeyDomain'
            );
        }


        $resourcePath = '/orgs/{org_id}/domains/{domain_id}/cloudflare';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($domain_id !== null) {
            $resourcePath = str_replace(
                '{' . 'domain_id' . '}',
                ObjectSerializer::toPathValue($domain_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getCloudflareNameServers
     *
     * Get CloudFlare name servers
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCloudflareNameServers'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\CloudFlareNameServers
     */
    public function getCloudflareNameServers($org_id, $domain_id, string $contentType = self::contentTypes['getCloudflareNameServers'][0])
    {
        list($response) = $this->getCloudflareNameServersWithHttpInfo($org_id, $domain_id, $contentType);
        return $response;
    }

    /**
     * Operation getCloudflareNameServersWithHttpInfo
     *
     * Get CloudFlare name servers
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCloudflareNameServers'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\CloudFlareNameServers, HTTP status code, HTTP response headers (array of strings)
     */
    public function getCloudflareNameServersWithHttpInfo($org_id, $domain_id, string $contentType = self::contentTypes['getCloudflareNameServers'][0])
    {
        $request = $this->getCloudflareNameServersRequest($org_id, $domain_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\OpenAPI\Client\Model\CloudFlareNameServers' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\OpenAPI\Client\Model\CloudFlareNameServers' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\OpenAPI\Client\Model\CloudFlareNameServers', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\OpenAPI\Client\Model\CloudFlareNameServers';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\CloudFlareNameServers',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getCloudflareNameServersAsync
     *
     * Get CloudFlare name servers
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCloudflareNameServers'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getCloudflareNameServersAsync($org_id, $domain_id, string $contentType = self::contentTypes['getCloudflareNameServers'][0])
    {
        return $this->getCloudflareNameServersAsyncWithHttpInfo($org_id, $domain_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getCloudflareNameServersAsyncWithHttpInfo
     *
     * Get CloudFlare name servers
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCloudflareNameServers'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getCloudflareNameServersAsyncWithHttpInfo($org_id, $domain_id, string $contentType = self::contentTypes['getCloudflareNameServers'][0])
    {
        $returnType = '\OpenAPI\Client\Model\CloudFlareNameServers';
        $request = $this->getCloudflareNameServersRequest($org_id, $domain_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getCloudflareNameServers'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCloudflareNameServers'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getCloudflareNameServersRequest($org_id, $domain_id, string $contentType = self::contentTypes['getCloudflareNameServers'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling getCloudflareNameServers'
            );
        }

        // verify the required parameter 'domain_id' is set
        if ($domain_id === null || (is_array($domain_id) && count($domain_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $domain_id when calling getCloudflareNameServers'
            );
        }


        $resourcePath = '/orgs/{org_id}/domains/{domain_id}/cloudflare/nameservers';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($domain_id !== null) {
            $resourcePath = str_replace(
                '{' . 'domain_id' . '}',
                ObjectSerializer::toPathValue($domain_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getDomains
     *
     * Get domains
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int $offset The offset from which to return items. (optional)
     * @param  int $limit The maximum number of items to return. (optional)
     * @param  string $sort_by The field by which to sort. (optional)
     * @param  string $sort_order The direction in which to sort. Possible values are &#39;asc&#39; and &#39;desc&#39;, defaulting to &#39;asc&#39;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getDomains'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\DomainsListing
     */
    public function getDomains($org_id, $offset = null, $limit = null, $sort_by = null, $sort_order = null, string $contentType = self::contentTypes['getDomains'][0])
    {
        list($response) = $this->getDomainsWithHttpInfo($org_id, $offset, $limit, $sort_by, $sort_order, $contentType);
        return $response;
    }

    /**
     * Operation getDomainsWithHttpInfo
     *
     * Get domains
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int $offset The offset from which to return items. (optional)
     * @param  int $limit The maximum number of items to return. (optional)
     * @param  string $sort_by The field by which to sort. (optional)
     * @param  string $sort_order The direction in which to sort. Possible values are &#39;asc&#39; and &#39;desc&#39;, defaulting to &#39;asc&#39;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getDomains'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\DomainsListing, HTTP status code, HTTP response headers (array of strings)
     */
    public function getDomainsWithHttpInfo($org_id, $offset = null, $limit = null, $sort_by = null, $sort_order = null, string $contentType = self::contentTypes['getDomains'][0])
    {
        $request = $this->getDomainsRequest($org_id, $offset, $limit, $sort_by, $sort_order, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\OpenAPI\Client\Model\DomainsListing' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\OpenAPI\Client\Model\DomainsListing' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\OpenAPI\Client\Model\DomainsListing', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\OpenAPI\Client\Model\DomainsListing';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\DomainsListing',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getDomainsAsync
     *
     * Get domains
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int $offset The offset from which to return items. (optional)
     * @param  int $limit The maximum number of items to return. (optional)
     * @param  string $sort_by The field by which to sort. (optional)
     * @param  string $sort_order The direction in which to sort. Possible values are &#39;asc&#39; and &#39;desc&#39;, defaulting to &#39;asc&#39;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getDomains'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getDomainsAsync($org_id, $offset = null, $limit = null, $sort_by = null, $sort_order = null, string $contentType = self::contentTypes['getDomains'][0])
    {
        return $this->getDomainsAsyncWithHttpInfo($org_id, $offset, $limit, $sort_by, $sort_order, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getDomainsAsyncWithHttpInfo
     *
     * Get domains
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int $offset The offset from which to return items. (optional)
     * @param  int $limit The maximum number of items to return. (optional)
     * @param  string $sort_by The field by which to sort. (optional)
     * @param  string $sort_order The direction in which to sort. Possible values are &#39;asc&#39; and &#39;desc&#39;, defaulting to &#39;asc&#39;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getDomains'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getDomainsAsyncWithHttpInfo($org_id, $offset = null, $limit = null, $sort_by = null, $sort_order = null, string $contentType = self::contentTypes['getDomains'][0])
    {
        $returnType = '\OpenAPI\Client\Model\DomainsListing';
        $request = $this->getDomainsRequest($org_id, $offset, $limit, $sort_by, $sort_order, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getDomains'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int $offset The offset from which to return items. (optional)
     * @param  int $limit The maximum number of items to return. (optional)
     * @param  string $sort_by The field by which to sort. (optional)
     * @param  string $sort_order The direction in which to sort. Possible values are &#39;asc&#39; and &#39;desc&#39;, defaulting to &#39;asc&#39;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getDomains'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getDomainsRequest($org_id, $offset = null, $limit = null, $sort_by = null, $sort_order = null, string $contentType = self::contentTypes['getDomains'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling getDomains'
            );
        }






        $resourcePath = '/orgs/{org_id}/domains';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $offset,
            'offset', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'limit', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $sort_by,
            'sortBy', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $sort_order,
            'sortOrder', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getWebsiteDomainDnsQuery
     *
     * Recursively query Dns servers for given domain
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $resolve_depth DNS query resolve depth, defaults to &#x60;short&#x60; if not provided. &#x60;short&#x60; -&gt; takes the shortest path to resolve domain IP. &#x60;detailed&#x60; -&gt; queries and returns output from all found Authoritative name servers. &#x60;queryAllTldNs&#x60; -&gt; queries and returns results from all TLD name servers (very expensive). (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWebsiteDomainDnsQuery'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\DnsQueryOutcome
     */
    public function getWebsiteDomainDnsQuery($org_id, $website_id, $domain_id, $resolve_depth = null, string $contentType = self::contentTypes['getWebsiteDomainDnsQuery'][0])
    {
        list($response) = $this->getWebsiteDomainDnsQueryWithHttpInfo($org_id, $website_id, $domain_id, $resolve_depth, $contentType);
        return $response;
    }

    /**
     * Operation getWebsiteDomainDnsQueryWithHttpInfo
     *
     * Recursively query Dns servers for given domain
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $resolve_depth DNS query resolve depth, defaults to &#x60;short&#x60; if not provided. &#x60;short&#x60; -&gt; takes the shortest path to resolve domain IP. &#x60;detailed&#x60; -&gt; queries and returns output from all found Authoritative name servers. &#x60;queryAllTldNs&#x60; -&gt; queries and returns results from all TLD name servers (very expensive). (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWebsiteDomainDnsQuery'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\DnsQueryOutcome, HTTP status code, HTTP response headers (array of strings)
     */
    public function getWebsiteDomainDnsQueryWithHttpInfo($org_id, $website_id, $domain_id, $resolve_depth = null, string $contentType = self::contentTypes['getWebsiteDomainDnsQuery'][0])
    {
        $request = $this->getWebsiteDomainDnsQueryRequest($org_id, $website_id, $domain_id, $resolve_depth, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\OpenAPI\Client\Model\DnsQueryOutcome' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\OpenAPI\Client\Model\DnsQueryOutcome' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\OpenAPI\Client\Model\DnsQueryOutcome', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\OpenAPI\Client\Model\DnsQueryOutcome';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\DnsQueryOutcome',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getWebsiteDomainDnsQueryAsync
     *
     * Recursively query Dns servers for given domain
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $resolve_depth DNS query resolve depth, defaults to &#x60;short&#x60; if not provided. &#x60;short&#x60; -&gt; takes the shortest path to resolve domain IP. &#x60;detailed&#x60; -&gt; queries and returns output from all found Authoritative name servers. &#x60;queryAllTldNs&#x60; -&gt; queries and returns results from all TLD name servers (very expensive). (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWebsiteDomainDnsQuery'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getWebsiteDomainDnsQueryAsync($org_id, $website_id, $domain_id, $resolve_depth = null, string $contentType = self::contentTypes['getWebsiteDomainDnsQuery'][0])
    {
        return $this->getWebsiteDomainDnsQueryAsyncWithHttpInfo($org_id, $website_id, $domain_id, $resolve_depth, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getWebsiteDomainDnsQueryAsyncWithHttpInfo
     *
     * Recursively query Dns servers for given domain
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $resolve_depth DNS query resolve depth, defaults to &#x60;short&#x60; if not provided. &#x60;short&#x60; -&gt; takes the shortest path to resolve domain IP. &#x60;detailed&#x60; -&gt; queries and returns output from all found Authoritative name servers. &#x60;queryAllTldNs&#x60; -&gt; queries and returns results from all TLD name servers (very expensive). (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWebsiteDomainDnsQuery'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getWebsiteDomainDnsQueryAsyncWithHttpInfo($org_id, $website_id, $domain_id, $resolve_depth = null, string $contentType = self::contentTypes['getWebsiteDomainDnsQuery'][0])
    {
        $returnType = '\OpenAPI\Client\Model\DnsQueryOutcome';
        $request = $this->getWebsiteDomainDnsQueryRequest($org_id, $website_id, $domain_id, $resolve_depth, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getWebsiteDomainDnsQuery'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $resolve_depth DNS query resolve depth, defaults to &#x60;short&#x60; if not provided. &#x60;short&#x60; -&gt; takes the shortest path to resolve domain IP. &#x60;detailed&#x60; -&gt; queries and returns output from all found Authoritative name servers. &#x60;queryAllTldNs&#x60; -&gt; queries and returns results from all TLD name servers (very expensive). (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWebsiteDomainDnsQuery'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getWebsiteDomainDnsQueryRequest($org_id, $website_id, $domain_id, $resolve_depth = null, string $contentType = self::contentTypes['getWebsiteDomainDnsQuery'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling getWebsiteDomainDnsQuery'
            );
        }

        // verify the required parameter 'website_id' is set
        if ($website_id === null || (is_array($website_id) && count($website_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $website_id when calling getWebsiteDomainDnsQuery'
            );
        }

        // verify the required parameter 'domain_id' is set
        if ($domain_id === null || (is_array($domain_id) && count($domain_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $domain_id when calling getWebsiteDomainDnsQuery'
            );
        }



        $resourcePath = '/orgs/{org_id}/websites/{website_id}/domains/{domain_id}/dns-query';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $resolve_depth,
            'resolveDepth', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($website_id !== null) {
            $resourcePath = str_replace(
                '{' . 'website_id' . '}',
                ObjectSerializer::toPathValue($website_id),
                $resourcePath
            );
        }
        // path params
        if ($domain_id !== null) {
            $resourcePath = str_replace(
                '{' . 'domain_id' . '}',
                ObjectSerializer::toPathValue($domain_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getWebsiteDomainMapping
     *
     * Returns website domain mapping
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWebsiteDomainMapping'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\DomainMapping
     */
    public function getWebsiteDomainMapping($org_id, $website_id, $domain_id, string $contentType = self::contentTypes['getWebsiteDomainMapping'][0])
    {
        list($response) = $this->getWebsiteDomainMappingWithHttpInfo($org_id, $website_id, $domain_id, $contentType);
        return $response;
    }

    /**
     * Operation getWebsiteDomainMappingWithHttpInfo
     *
     * Returns website domain mapping
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWebsiteDomainMapping'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\DomainMapping, HTTP status code, HTTP response headers (array of strings)
     */
    public function getWebsiteDomainMappingWithHttpInfo($org_id, $website_id, $domain_id, string $contentType = self::contentTypes['getWebsiteDomainMapping'][0])
    {
        $request = $this->getWebsiteDomainMappingRequest($org_id, $website_id, $domain_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\OpenAPI\Client\Model\DomainMapping' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\OpenAPI\Client\Model\DomainMapping' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\OpenAPI\Client\Model\DomainMapping', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\OpenAPI\Client\Model\DomainMapping';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\DomainMapping',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getWebsiteDomainMappingAsync
     *
     * Returns website domain mapping
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWebsiteDomainMapping'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getWebsiteDomainMappingAsync($org_id, $website_id, $domain_id, string $contentType = self::contentTypes['getWebsiteDomainMapping'][0])
    {
        return $this->getWebsiteDomainMappingAsyncWithHttpInfo($org_id, $website_id, $domain_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getWebsiteDomainMappingAsyncWithHttpInfo
     *
     * Returns website domain mapping
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWebsiteDomainMapping'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getWebsiteDomainMappingAsyncWithHttpInfo($org_id, $website_id, $domain_id, string $contentType = self::contentTypes['getWebsiteDomainMapping'][0])
    {
        $returnType = '\OpenAPI\Client\Model\DomainMapping';
        $request = $this->getWebsiteDomainMappingRequest($org_id, $website_id, $domain_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getWebsiteDomainMapping'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWebsiteDomainMapping'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getWebsiteDomainMappingRequest($org_id, $website_id, $domain_id, string $contentType = self::contentTypes['getWebsiteDomainMapping'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling getWebsiteDomainMapping'
            );
        }

        // verify the required parameter 'website_id' is set
        if ($website_id === null || (is_array($website_id) && count($website_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $website_id when calling getWebsiteDomainMapping'
            );
        }

        // verify the required parameter 'domain_id' is set
        if ($domain_id === null || (is_array($domain_id) && count($domain_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $domain_id when calling getWebsiteDomainMapping'
            );
        }


        $resourcePath = '/orgs/{org_id}/websites/{website_id}/domains/{domain_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($website_id !== null) {
            $resourcePath = str_replace(
                '{' . 'website_id' . '}',
                ObjectSerializer::toPathValue($website_id),
                $resourcePath
            );
        }
        // path params
        if ($domain_id !== null) {
            $resourcePath = str_replace(
                '{' . 'domain_id' . '}',
                ObjectSerializer::toPathValue($domain_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getWebsiteDomainMappingDnsStatus
     *
     * Returns website domain mapping DNS status
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWebsiteDomainMappingDnsStatus'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\DnsStatus
     */
    public function getWebsiteDomainMappingDnsStatus($org_id, $website_id, $domain_id, string $contentType = self::contentTypes['getWebsiteDomainMappingDnsStatus'][0])
    {
        list($response) = $this->getWebsiteDomainMappingDnsStatusWithHttpInfo($org_id, $website_id, $domain_id, $contentType);
        return $response;
    }

    /**
     * Operation getWebsiteDomainMappingDnsStatusWithHttpInfo
     *
     * Returns website domain mapping DNS status
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWebsiteDomainMappingDnsStatus'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\DnsStatus, HTTP status code, HTTP response headers (array of strings)
     */
    public function getWebsiteDomainMappingDnsStatusWithHttpInfo($org_id, $website_id, $domain_id, string $contentType = self::contentTypes['getWebsiteDomainMappingDnsStatus'][0])
    {
        $request = $this->getWebsiteDomainMappingDnsStatusRequest($org_id, $website_id, $domain_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\OpenAPI\Client\Model\DnsStatus' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\OpenAPI\Client\Model\DnsStatus' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\OpenAPI\Client\Model\DnsStatus', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\OpenAPI\Client\Model\DnsStatus';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\DnsStatus',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getWebsiteDomainMappingDnsStatusAsync
     *
     * Returns website domain mapping DNS status
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWebsiteDomainMappingDnsStatus'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getWebsiteDomainMappingDnsStatusAsync($org_id, $website_id, $domain_id, string $contentType = self::contentTypes['getWebsiteDomainMappingDnsStatus'][0])
    {
        return $this->getWebsiteDomainMappingDnsStatusAsyncWithHttpInfo($org_id, $website_id, $domain_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getWebsiteDomainMappingDnsStatusAsyncWithHttpInfo
     *
     * Returns website domain mapping DNS status
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWebsiteDomainMappingDnsStatus'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getWebsiteDomainMappingDnsStatusAsyncWithHttpInfo($org_id, $website_id, $domain_id, string $contentType = self::contentTypes['getWebsiteDomainMappingDnsStatus'][0])
    {
        $returnType = '\OpenAPI\Client\Model\DnsStatus';
        $request = $this->getWebsiteDomainMappingDnsStatusRequest($org_id, $website_id, $domain_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getWebsiteDomainMappingDnsStatus'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWebsiteDomainMappingDnsStatus'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getWebsiteDomainMappingDnsStatusRequest($org_id, $website_id, $domain_id, string $contentType = self::contentTypes['getWebsiteDomainMappingDnsStatus'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling getWebsiteDomainMappingDnsStatus'
            );
        }

        // verify the required parameter 'website_id' is set
        if ($website_id === null || (is_array($website_id) && count($website_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $website_id when calling getWebsiteDomainMappingDnsStatus'
            );
        }

        // verify the required parameter 'domain_id' is set
        if ($domain_id === null || (is_array($domain_id) && count($domain_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $domain_id when calling getWebsiteDomainMappingDnsStatus'
            );
        }


        $resourcePath = '/orgs/{org_id}/websites/{website_id}/domains/{domain_id}/dns-status';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($website_id !== null) {
            $resourcePath = str_replace(
                '{' . 'website_id' . '}',
                ObjectSerializer::toPathValue($website_id),
                $resourcePath
            );
        }
        // path params
        if ($domain_id !== null) {
            $resourcePath = str_replace(
                '{' . 'domain_id' . '}',
                ObjectSerializer::toPathValue($domain_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getWebsiteDomainMappings
     *
     * Get website&#39;s mapped domains
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  bool $with_ssl If set to true, domains are returned with applicable ssl certificates. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWebsiteDomainMappings'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\DomainMappingsFullListing
     */
    public function getWebsiteDomainMappings($org_id, $website_id, $with_ssl = null, string $contentType = self::contentTypes['getWebsiteDomainMappings'][0])
    {
        list($response) = $this->getWebsiteDomainMappingsWithHttpInfo($org_id, $website_id, $with_ssl, $contentType);
        return $response;
    }

    /**
     * Operation getWebsiteDomainMappingsWithHttpInfo
     *
     * Get website&#39;s mapped domains
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  bool $with_ssl If set to true, domains are returned with applicable ssl certificates. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWebsiteDomainMappings'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\DomainMappingsFullListing, HTTP status code, HTTP response headers (array of strings)
     */
    public function getWebsiteDomainMappingsWithHttpInfo($org_id, $website_id, $with_ssl = null, string $contentType = self::contentTypes['getWebsiteDomainMappings'][0])
    {
        $request = $this->getWebsiteDomainMappingsRequest($org_id, $website_id, $with_ssl, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\OpenAPI\Client\Model\DomainMappingsFullListing' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\OpenAPI\Client\Model\DomainMappingsFullListing' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\OpenAPI\Client\Model\DomainMappingsFullListing', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\OpenAPI\Client\Model\DomainMappingsFullListing';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\DomainMappingsFullListing',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getWebsiteDomainMappingsAsync
     *
     * Get website&#39;s mapped domains
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  bool $with_ssl If set to true, domains are returned with applicable ssl certificates. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWebsiteDomainMappings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getWebsiteDomainMappingsAsync($org_id, $website_id, $with_ssl = null, string $contentType = self::contentTypes['getWebsiteDomainMappings'][0])
    {
        return $this->getWebsiteDomainMappingsAsyncWithHttpInfo($org_id, $website_id, $with_ssl, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getWebsiteDomainMappingsAsyncWithHttpInfo
     *
     * Get website&#39;s mapped domains
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  bool $with_ssl If set to true, domains are returned with applicable ssl certificates. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWebsiteDomainMappings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getWebsiteDomainMappingsAsyncWithHttpInfo($org_id, $website_id, $with_ssl = null, string $contentType = self::contentTypes['getWebsiteDomainMappings'][0])
    {
        $returnType = '\OpenAPI\Client\Model\DomainMappingsFullListing';
        $request = $this->getWebsiteDomainMappingsRequest($org_id, $website_id, $with_ssl, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getWebsiteDomainMappings'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  bool $with_ssl If set to true, domains are returned with applicable ssl certificates. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWebsiteDomainMappings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getWebsiteDomainMappingsRequest($org_id, $website_id, $with_ssl = null, string $contentType = self::contentTypes['getWebsiteDomainMappings'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling getWebsiteDomainMappings'
            );
        }

        // verify the required parameter 'website_id' is set
        if ($website_id === null || (is_array($website_id) && count($website_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $website_id when calling getWebsiteDomainMappings'
            );
        }



        $resourcePath = '/orgs/{org_id}/websites/{website_id}/domains';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $with_ssl,
            'withSsl', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($website_id !== null) {
            $resourcePath = str_replace(
                '{' . 'website_id' . '}',
                ObjectSerializer::toPathValue($website_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation setCloudflareApiKeyId
     *
     * Set CloudFlare API key, domain level
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $body Cloudflare API key ID. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setCloudflareApiKeyId'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function setCloudflareApiKeyId($org_id, $domain_id, $body, string $contentType = self::contentTypes['setCloudflareApiKeyId'][0])
    {
        $this->setCloudflareApiKeyIdWithHttpInfo($org_id, $domain_id, $body, $contentType);
    }

    /**
     * Operation setCloudflareApiKeyIdWithHttpInfo
     *
     * Set CloudFlare API key, domain level
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $body Cloudflare API key ID. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setCloudflareApiKeyId'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function setCloudflareApiKeyIdWithHttpInfo($org_id, $domain_id, $body, string $contentType = self::contentTypes['setCloudflareApiKeyId'][0])
    {
        $request = $this->setCloudflareApiKeyIdRequest($org_id, $domain_id, $body, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation setCloudflareApiKeyIdAsync
     *
     * Set CloudFlare API key, domain level
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $body Cloudflare API key ID. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setCloudflareApiKeyId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function setCloudflareApiKeyIdAsync($org_id, $domain_id, $body, string $contentType = self::contentTypes['setCloudflareApiKeyId'][0])
    {
        return $this->setCloudflareApiKeyIdAsyncWithHttpInfo($org_id, $domain_id, $body, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation setCloudflareApiKeyIdAsyncWithHttpInfo
     *
     * Set CloudFlare API key, domain level
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $body Cloudflare API key ID. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setCloudflareApiKeyId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function setCloudflareApiKeyIdAsyncWithHttpInfo($org_id, $domain_id, $body, string $contentType = self::contentTypes['setCloudflareApiKeyId'][0])
    {
        $returnType = '';
        $request = $this->setCloudflareApiKeyIdRequest($org_id, $domain_id, $body, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'setCloudflareApiKeyId'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $body Cloudflare API key ID. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setCloudflareApiKeyId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function setCloudflareApiKeyIdRequest($org_id, $domain_id, $body, string $contentType = self::contentTypes['setCloudflareApiKeyId'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling setCloudflareApiKeyId'
            );
        }

        // verify the required parameter 'domain_id' is set
        if ($domain_id === null || (is_array($domain_id) && count($domain_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $domain_id when calling setCloudflareApiKeyId'
            );
        }

        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling setCloudflareApiKeyId'
            );
        }


        $resourcePath = '/orgs/{org_id}/domains/{domain_id}/cloudflare';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($domain_id !== null) {
            $resourcePath = str_replace(
                '{' . 'domain_id' . '}',
                ObjectSerializer::toPathValue($domain_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($body)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($body));
            } else {
                $httpBody = $body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateWebsiteDomainMapping
     *
     * Update website domain mapping
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  \OpenAPI\Client\Model\DomainMappingUpdate $domain_mapping_update domain_mapping_update (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateWebsiteDomainMapping'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function updateWebsiteDomainMapping($org_id, $website_id, $domain_id, $domain_mapping_update, string $contentType = self::contentTypes['updateWebsiteDomainMapping'][0])
    {
        $this->updateWebsiteDomainMappingWithHttpInfo($org_id, $website_id, $domain_id, $domain_mapping_update, $contentType);
    }

    /**
     * Operation updateWebsiteDomainMappingWithHttpInfo
     *
     * Update website domain mapping
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  \OpenAPI\Client\Model\DomainMappingUpdate $domain_mapping_update (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateWebsiteDomainMapping'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateWebsiteDomainMappingWithHttpInfo($org_id, $website_id, $domain_id, $domain_mapping_update, string $contentType = self::contentTypes['updateWebsiteDomainMapping'][0])
    {
        $request = $this->updateWebsiteDomainMappingRequest($org_id, $website_id, $domain_id, $domain_mapping_update, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation updateWebsiteDomainMappingAsync
     *
     * Update website domain mapping
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  \OpenAPI\Client\Model\DomainMappingUpdate $domain_mapping_update (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateWebsiteDomainMapping'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateWebsiteDomainMappingAsync($org_id, $website_id, $domain_id, $domain_mapping_update, string $contentType = self::contentTypes['updateWebsiteDomainMapping'][0])
    {
        return $this->updateWebsiteDomainMappingAsyncWithHttpInfo($org_id, $website_id, $domain_id, $domain_mapping_update, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateWebsiteDomainMappingAsyncWithHttpInfo
     *
     * Update website domain mapping
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  \OpenAPI\Client\Model\DomainMappingUpdate $domain_mapping_update (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateWebsiteDomainMapping'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateWebsiteDomainMappingAsyncWithHttpInfo($org_id, $website_id, $domain_id, $domain_mapping_update, string $contentType = self::contentTypes['updateWebsiteDomainMapping'][0])
    {
        $returnType = '';
        $request = $this->updateWebsiteDomainMappingRequest($org_id, $website_id, $domain_id, $domain_mapping_update, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateWebsiteDomainMapping'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  \OpenAPI\Client\Model\DomainMappingUpdate $domain_mapping_update (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateWebsiteDomainMapping'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateWebsiteDomainMappingRequest($org_id, $website_id, $domain_id, $domain_mapping_update, string $contentType = self::contentTypes['updateWebsiteDomainMapping'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling updateWebsiteDomainMapping'
            );
        }

        // verify the required parameter 'website_id' is set
        if ($website_id === null || (is_array($website_id) && count($website_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $website_id when calling updateWebsiteDomainMapping'
            );
        }

        // verify the required parameter 'domain_id' is set
        if ($domain_id === null || (is_array($domain_id) && count($domain_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $domain_id when calling updateWebsiteDomainMapping'
            );
        }

        // verify the required parameter 'domain_mapping_update' is set
        if ($domain_mapping_update === null || (is_array($domain_mapping_update) && count($domain_mapping_update) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $domain_mapping_update when calling updateWebsiteDomainMapping'
            );
        }


        $resourcePath = '/orgs/{org_id}/websites/{website_id}/domains/{domain_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($website_id !== null) {
            $resourcePath = str_replace(
                '{' . 'website_id' . '}',
                ObjectSerializer::toPathValue($website_id),
                $resourcePath
            );
        }
        // path params
        if ($domain_id !== null) {
            $resourcePath = str_replace(
                '{' . 'domain_id' . '}',
                ObjectSerializer::toPathValue($domain_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($domain_mapping_update)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($domain_mapping_update));
            } else {
                $httpBody = $domain_mapping_update;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PATCH',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateWebsitePrimaryDomain
     *
     * Update primary domain mapping
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  \OpenAPI\Client\Model\NewPrimaryDomainMapping $new_primary_domain_mapping Domain mapping details. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateWebsitePrimaryDomain'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function updateWebsitePrimaryDomain($org_id, $website_id, $new_primary_domain_mapping, string $contentType = self::contentTypes['updateWebsitePrimaryDomain'][0])
    {
        $this->updateWebsitePrimaryDomainWithHttpInfo($org_id, $website_id, $new_primary_domain_mapping, $contentType);
    }

    /**
     * Operation updateWebsitePrimaryDomainWithHttpInfo
     *
     * Update primary domain mapping
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  \OpenAPI\Client\Model\NewPrimaryDomainMapping $new_primary_domain_mapping Domain mapping details. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateWebsitePrimaryDomain'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateWebsitePrimaryDomainWithHttpInfo($org_id, $website_id, $new_primary_domain_mapping, string $contentType = self::contentTypes['updateWebsitePrimaryDomain'][0])
    {
        $request = $this->updateWebsitePrimaryDomainRequest($org_id, $website_id, $new_primary_domain_mapping, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation updateWebsitePrimaryDomainAsync
     *
     * Update primary domain mapping
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  \OpenAPI\Client\Model\NewPrimaryDomainMapping $new_primary_domain_mapping Domain mapping details. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateWebsitePrimaryDomain'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateWebsitePrimaryDomainAsync($org_id, $website_id, $new_primary_domain_mapping, string $contentType = self::contentTypes['updateWebsitePrimaryDomain'][0])
    {
        return $this->updateWebsitePrimaryDomainAsyncWithHttpInfo($org_id, $website_id, $new_primary_domain_mapping, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateWebsitePrimaryDomainAsyncWithHttpInfo
     *
     * Update primary domain mapping
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  \OpenAPI\Client\Model\NewPrimaryDomainMapping $new_primary_domain_mapping Domain mapping details. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateWebsitePrimaryDomain'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateWebsitePrimaryDomainAsyncWithHttpInfo($org_id, $website_id, $new_primary_domain_mapping, string $contentType = self::contentTypes['updateWebsitePrimaryDomain'][0])
    {
        $returnType = '';
        $request = $this->updateWebsitePrimaryDomainRequest($org_id, $website_id, $new_primary_domain_mapping, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateWebsitePrimaryDomain'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  \OpenAPI\Client\Model\NewPrimaryDomainMapping $new_primary_domain_mapping Domain mapping details. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateWebsitePrimaryDomain'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateWebsitePrimaryDomainRequest($org_id, $website_id, $new_primary_domain_mapping, string $contentType = self::contentTypes['updateWebsitePrimaryDomain'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling updateWebsitePrimaryDomain'
            );
        }

        // verify the required parameter 'website_id' is set
        if ($website_id === null || (is_array($website_id) && count($website_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $website_id when calling updateWebsitePrimaryDomain'
            );
        }

        // verify the required parameter 'new_primary_domain_mapping' is set
        if ($new_primary_domain_mapping === null || (is_array($new_primary_domain_mapping) && count($new_primary_domain_mapping) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $new_primary_domain_mapping when calling updateWebsitePrimaryDomain'
            );
        }


        $resourcePath = '/orgs/{org_id}/websites/{website_id}/domains/primary';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($website_id !== null) {
            $resourcePath = str_replace(
                '{' . 'website_id' . '}',
                ObjectSerializer::toPathValue($website_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($new_primary_domain_mapping)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($new_primary_domain_mapping));
            } else {
                $httpBody = $new_primary_domain_mapping;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
